package client;

import java.net.URL;

public class Client {
	public static void main(String[] args) throws Exception {
		String name;

		if ( args.length < 1 ){
			System.err.println ("Usage:: java -cp %hpws_cp% client.Client <name> [<loop>]" );
			System.exit(1);
		}

		name = args[0];

		Hello service = new Hello();
		HelloPortType portType = service.getHelloPort();

		String result = portType.greet(name);

		System.out.println("greet() returned: " + result);

		if (args.length > 1){ // Measure response time.
			int loopCount = Integer.parseInt(args[1]);
			for (int r = 0; r < 4; r++){	// Four rounds of measurement
				long ts = System.currentTimeMillis();
				for (int i = 0; i < loopCount; i++){
					String res = portType.greet(name);
				}
				long te = System.currentTimeMillis();
				System.out.println("[" + r + "] Avg. response time = " + ((te - ts)/loopCount) + " ms.");
			}
		}
	}
}