@echo off

rem edit this file to point HPWS_CONTEXT_URL and HPWS_CLASS_DIR to point to the right
rem place in your setup.

if not "%JAVA_HOME%" == "" goto gotJavaHome
echo You must set JAVA_HOME to point at your Java Development Kit installation
goto cleanup
:gotJavaHome

call setHPWSEnv

if not "%HPWS_CONTEXT_URL%" == "" goto gotHPWSContextURL
echo You must set HPWS_CONTEXT_URL to point at HPWS Servlet Context URL ..
goto cleanup
:gotHPWSContextURL

if not "%HPWS_SERVLET_DIR%" == "" goto gotHPWSServletDir
echo You must set HPWS_SERVLET_DIR to point at HPWS Servlet directory ..
goto cleanup
:gotHPWSServletDir

%JAVA_HOME%\bin\javac Hello.java

rem -------------------------------------------------------------------------------
rem Copied contents of ClassToWebService.bat as this doesn't support JAVA_OPTS
rem -------------------------------------------------------------------------------
call HPWSenv.bat

set JAVA_CMD=%HPWS_JHOME%\bin\java %JAVA_OPTS% -classpath "%HPWS_CP%;%CLASSPATH%"
set WSDL_GEN_CLASS=com.hp.soap.tools.ClassToWSDL
set SVC_CFG_GEN_CLASS=com.hp.soap.tools.ClassToServiceConfig

set JAVACLASS=Hello
set ENDPOINT=%HPWS_CONTEXT_URL%/soap/HelloService
set SVCNAME=HelloService
set WSDLFILE=%4

set ADAPTER=rpc-java
set VALIDATION=false
set LOOKUPNAME=%JAVACLASS%

if %JAVACLASS%x==x goto errmsg
if %ENDPOINT%x==x goto errmsg
if %SVCNAME%x==x goto errmsg

set SVCDIR=%HPWS_HOME%\webapps\hpws\webservices\%SVCNAME%


rem **************************
rem Check for target directory
rem **************************
if NOT EXIST %SVCDIR% goto makedir
goto direxists

:makedir
echo Creating a directory %SVCDIR%
mkdir %SVCDIR%
if NOT EXIST %SVCDIR% goto svc_dir_errmsg

:direxists


rem *************************
rem Check for WSDL arg
rem *************************
if NOT %WSDLFILE%x==x goto copywsdl

echo Generating WSDL for %SVCNAME%
@%JAVA_CMD% %WSDL_GEN_CLASS% %JAVACLASS% %ENDPOINT% > %SVCDIR%\%SVCNAME%.wsdl
goto regsvc

:copywsdl
copy %WSDLFILE% %SVCDIR%\%SVCNAME%.wsdl

rem *************************
rem Register service
rem *************************
:regsvc
echo Generating Service Registration File for %SVCNAME%
@%JAVA_CMD% %SVC_CFG_GEN_CLASS% %ADAPTER% %JAVACLASS% %VALIDATION% > %SVCDIR%\%SVCNAME%.xml


echo ************************************************************************************
echo To complete the deployment of %SVCNAME%
echo Make sure that the Java class %JAVACLASS% and its dependencies are in your classpath.
echo You may use the 'classes' or 'lib'  subdirectory under %HPWS_HOME%\webapps\hpws\WEB-INF.
echo ************************************************************************************
goto exit


rem *************************
rem Error notification
rem *************************
:errmsg
echo ***************************
echo Missing a required argument!!
echo Usage:

echo 	ClassToWebService "Java Class Name" "Service Endpoint URL" "Service Name" "WSDL file (optional)"
echo ***************************
goto exit

:svc_dir_errmsg
echo ************************************
echo Unable to create directory %SVCDIR%
goto exit

copy Hello.class %HPWS_SERVLET_DIR%\WEB-INF\classes

:exit
:cleanup